#ifndef _TCPHANDLER_CPP
#define _TCPHANDLER_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#define WIN32_LEAN_AND_MEAN
#define _WIN32_WINNT 0x0500

#include <Windows.H>
#include <WinSock2.H>
#include <WinSock.H>
#include <Stdio.H>
#include <Stdlib.H>
#include <IOStream>

#include "SockServer.H"
#include "../Source/Routines.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

HANDLE ghEvent_TCPHandler = NULL;

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool SocketServer::Start_TCPHandler(void)
{
    #ifdef _DEBUG_SOCK_SERVER
    printf("DEBUG: [In Proc]> SocketServer::Start_TCPHandler.\n");
    #endif

    ghEvent_TCPHandler = CreateEvent(NULL, FALSE, FALSE, "TCPHandler_Thread_Function");

    if((hcTCPHandler_Thread_Handle = CreateThread(NULL, 0, (LPTHREAD_START_ROUTINE)TCPHandler_Thread_Function, (LPVOID) this, 0, (LPDWORD) &dwcTCPHandler_Thread_ID)) == NULL)
    {
		WriteSysLog("SocketServer::Start_TCPHandler : CreateThread failed.");
        CloseHandle(ghEvent_TCPHandler);
        return false;
    }

    if(WaitForSingleObject(ghEvent_TCPHandler, 5000) == WAIT_TIMEOUT)
    {
        CloseHandle(ghEvent_TCPHandler);
        return false;
    }

    CloseHandle(ghEvent_TCPHandler);
    return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool SocketServer::Stop_TCPHandler(void)
{
    #ifdef _DEBUG_SOCK_SERVER
    printf("DEBUG: [In Proc]> SocketServer::Stop_TCPHandler.\n");
    #endif

    DWORD dwExitCode = 0;

    if(bcTCPHandlerActive)
    {
        bcShutdownTCPHandler = true;

        while(GetExitCodeThread(hcTCPHandler_Thread_Handle, &dwExitCode))
        {
            if(dwExitCode != STILL_ACTIVE)
            {
                CloseHandle(hcTCPHandler_Thread_Handle);
                dwcTCPHandler_Thread_ID = 0;
                return true;
            }
            Sleep(1);
        }

		WriteSysLog("SocketServer::Stop_TCPHandler : GetExitCodeThread failed.");

        return false;
    }

    return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

DWORD WINAPI TCPHandler_Thread_Function(LPVOID pvThread)
{
    #ifdef _DEBUG_SOCK_SERVER
    printf("DEBUG: [In Proc]> TCPHandler_Thread_Function.\n");
    #endif

    //---------------------(Initialize Thread [Begin])----------
	SocketServer* pSockSrvr = (SocketServer *) pvThread;

    pSockSrvr->bcShutdownTCPHandler = false;
    pSockSrvr->bcTCPHandlerActive = true;

	pSockSrvr->TimeOut.tv_sec	= 1;
	pSockSrvr->TimeOut.tv_usec = 0;

	FD_ZERO(&pSockSrvr->ReadFDS);
	FD_ZERO(&pSockSrvr->WriteFDS);
	FD_ZERO(&pSockSrvr->ExceptFDS);

    SetEvent(ghEvent_TCPHandler);
    //---------------------(Initialize Thread [END])----------

	int iClient = 0;

    while(!pSockSrvr->bcShutdownTCPHandler)
    {
        // Zero the Read, Write and Except
    	FD_ZERO(&pSockSrvr->ReadFDS);
    	FD_ZERO(&pSockSrvr->WriteFDS);
    	FD_ZERO(&pSockSrvr->ExceptFDS);

        if(!pSockSrvr->IsListeningServer)
        {
            while(pSockSrvr->icCurrentClients == 0)
            {
                if(pSockSrvr->bcShutdownTCPHandler)
                {
                    break;
                }
                Sleep(TCPHANDLER_MS_WAIT);
            }
            if(pSockSrvr->bcShutdownTCPHandler)
            {
                break;
            }
        }
        else {
            // Set LocalListenSocket socket to Read, Except
    		FD_SET(pSockSrvr->sckcListenSocket, &pSockSrvr->ReadFDS);
    		FD_SET(pSockSrvr->sckcListenSocket, &pSockSrvr->ExceptFDS);
        }

		// Set all connected clients to Read, Write and Except
		iClient = 0;
		while(iClient < pSockSrvr->icMaxClients)
		{
			if( pSockSrvr->bcConnected[iClient] == true)
			{
				FD_SET(pSockSrvr->sckcSocket[iClient], &pSockSrvr->ReadFDS);
				FD_SET(pSockSrvr->sckcSocket[iClient], &pSockSrvr->WriteFDS);
				FD_SET(pSockSrvr->sckcSocket[iClient], &pSockSrvr->ExceptFDS);
			}
			iClient++;
		}

		// Socket Select...
		if(select(-1, &pSockSrvr->ReadFDS, &pSockSrvr->WriteFDS, &pSockSrvr->ExceptFDS, &pSockSrvr->TimeOut) == SOCKET_ERROR)
		{
			WriteSysLog("TCPHandler_Thread_Function :: Scoket select error.");
			return -1;
		}

        if(pSockSrvr->IsListeningServer)
        {
    		// Accept any incoming connections.
    		pSockSrvr->DoAccept();
        }

		// Send and receive any pending data.
		if(pSockSrvr->icCurrentClients > 0)
		{
    		iClient = 0;
			while(iClient < pSockSrvr->icMaxClients)
			{
				if( pSockSrvr->bcConnected[iClient] == true)
				{
                	if( FD_ISSET(pSockSrvr->sckcSocket[iClient], &pSockSrvr->WriteFDS) )
                	{
					    if(TryEnterCriticalSection(&pSockSrvr->CriticalSection1))
						{
	    					pSockSrvr->DoSend(iClient);
							LeaveCriticalSection(&pSockSrvr->CriticalSection1);
						}
                    }

                	if( FD_ISSET(pSockSrvr->sckcSocket[iClient], &pSockSrvr->ReadFDS) )
                	{
					    if(TryEnterCriticalSection(&pSockSrvr->CriticalSection1))
						{
	    					pSockSrvr->DoRecv(iClient);
							LeaveCriticalSection(&pSockSrvr->CriticalSection1);
						}
                    }

                	if( FD_ISSET(pSockSrvr->sckcSocket[iClient], &pSockSrvr->ExceptFDS) )
                	{
        				pSockSrvr->bcDisconnect[iClient] = true;
                    }
				}
				iClient++;
			}

    		// Disconnect any pending disconnects.
    		iClient = 0;
			while(iClient < pSockSrvr->icMaxClients)
			{
				if( pSockSrvr->bcDisconnect[iClient] == true)
                {
                    pSockSrvr->DisconnectClient(iClient);
                }
				iClient++;
			}
		}

        Sleep(TCPHANDLER_MS_WAIT);
	}

    pSockSrvr->bcTCPHandlerActive = false;

	return 0;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif

